﻿# ブラインドパーツツール

## バージョン
1.0.0

## 概要
本ツールは、iCAD SX 上のパーツについて、パーツ名やコメントの検索条件に一致するパーツのブラインド化を行ったり解除したりするツールです。

## 導入前の注意事項
* 導入前に必ず、**iCADインストールフォルダごとバックアップ**を作成してください。
* 本ツールはiCADのSDKを利用して作成されています。あらかじめiCAD SX の.NET連携機能を有効にしてください。
    * .NET連携機能有効化の手順
    1. スタートメニュー → iCAD SX 環境設定ツール → .NET連携セットアップ を起動する。
    2. ポート番号を「3999」（初期設定値のまま）にし、「.NET連携を有効にする」のチェックをONにする。     
* 本ツールはあらかじめテストをしてから配布をしておりますが、万が一損害が生じた場合の一切の責任を負いかねますので、ご了承ください。

## テスト実施済環境
### iCAD SXのバージョン
V8L2
### OS
Windows 11

## インストール
1. ダウンロードファイルを解凍する
2. BlindPartsTool.exeを**iCADインストールフォルダ\USER\BIN**へコピー

## 使用方法

### BlindPartsTool.exeの実行
#### コマンドメニューもしくはアイコンメニューへ登録
- 任意でコマンドメニューもしくはアイコンメニューへ登録してください。
#### MirrorPartsChecker.exeの実行
- 登録したメニュー（コマンドメニュー、アイコンメニュー）　　
- iCAD_キー入力領域からのexe実行[;EXEC /%ICADDIR%\USER\BIN\BlindPartsTool.exe/ @GO]　
- iCAD_アプリ実行
- exeの直接起動 

上記各方法により実行できます。

### 検索実行
検索ワード欄にパーツ名やコメントの一部を入力し、*実行*ボタンをクリックすると、条件に一致するパーツがブラインド化されます。
検索モードは以下の5種類があります。
- 前方一致
- 部分一致
- 後方一致
- 完全一致
- 正規表現

ブラインド対象のパーツが100件を超える場合、100件ずつブラインド化処理がされます。

ブラインド化モードが*ブラインド化解除*の場合、条件に一致するパーツのブラインド化が解除されます。

検索対象が*パーツ名*の場合、パーツ名に対して検索が行われます。

検索対象が*コメント*の場合、コメントに対して検索が行われます。


### お気に入り機能について
*お気に入りに追加*をクリックすると、現在の設定をお気に入りとして保存できます。

追加されたお気に入りをダブルクリックすると、その設定でブラインド化が実行/解除されます。

リスト行をドラッグすることでお気に入りの順番を変更できます。

リスト行を右クリックし、削除をクリックすると、行の削除ができます。

お気に入りの状態はアプリケーションデータのディレクトリに保存されます。
(例: C:\Users\<User>\AppData\Roaming\BlindPartsTool)

初期化したい場合はこのディレクトリ内のiniファイルを削除してください。

### その他の実行/解除ボタン
検索実行以外に以下の実行ボタンがあります。
#### 指定実行
指定したパーツをブラインド化します。iCAD SX のビューリストにおける*ブラインドパーツ設定*と同様の機能です。
#### 指定外実行
指定したパーツ以外のパーツをブラインド化します。iCAD SX のビューリストにおける*指定以外をブラインドパーツ設定*と同様の機能です。
#### 指定解除
指定したパーツのブラインド化を解除します。
#### 全パーツ実行
全パーツをブラインド化します。
#### 全パーツ解除
全パーツのブラインド化を解除します。iCAD SX のビューリストにおける*ブラインドパーツ設定をリセット*と同様の機能です。


## 著作権/利用条件/免責等について
* 本プログラムに関する著作権等の知的財産権はものづくりのススメ-しれっとプロジェクトに帰属します
* 本プログラムは一切の保証なく、現状で提供されるものであり、正常動作等について作者は保証を行いません
* 本プログラムに関して発生するいかなる問題も利用者の責任により解決されるものとします
* 本プログラムに関して発生するいかなる損害に対しても作者は責任を負いません

上記に同意される場合のみ、本プログラムをご利用ください。

## 連絡先
本プログラムに関する不具合、ご要望等は[「ものづくりのススメ」お問い合わせフォーム](https://forms.gle/99xG3r8NDN7NX5QH9)よりご連絡ください。

---
Copyright (c) 2025 ものづくりのススメ-しれっとプロジェクト all aights reserved. 