# 製図補助ツール

## バージョン
1.1.0

## 概要
本ツールは、iCAD SX で製図作業を行う際によく使うコマンドや便利な機能を集約したツールです。

## 導入前の注意事項
* 導入前に必ず、**iCADインストールフォルダごとバックアップ**を作成してください。
* 本ツールはiCADのSDKを利用して作成されています。あらかじめiCAD SX の.NET連携機能を有効にしてください。
    * .NET連携機能有効化の手順
    1. スタートメニュー → iCAD SX 環境設定ツール → .NET連携セットアップ を起動する。
    2. ポート番号を「3999」（初期設定値のまま）にし、「.NET連携を有効にする」のチェックをONにする。     
* 本ツールはあらかじめテストをしてから配布をしておりますが、万が一損害が生じた場合の一切の責任を負いかねますので、ご了承ください。

## テスト実施済環境
### iCAD SXのバージョン
V8L2
### OS
Windows 11

## インストール
1. ダウンロードファイルを解凍する
2. **DimensioningTool.exe**を**iCADインストールフォルダ\USER\BIN**へコピー

## 使用方法
1. DimensioningTool.exe を実行してください
2. 各ボタンをクリックして、使用してください

### 半自動製図ツールについて
* 三次元モデルから半自動的に六面図を作成します。
* ビュー間距離を短くしすぎるとエラーが出ます。エラーが出た場合はビュー間距離を大きくして再度実行してください。

### 現状を保存/保存状態を呼出について
現状を保存 するとチェックボックスやラジオボタンの状態を保存します。
保存ファイルはアプリケーションデータのディレクトリに保存されます。
(例: C:\Users\<User>\AppData\Roaming\DimensioningTool)
初期化したい場合はこのディレクトリ内のiniファイルを削除してください。

### 穴寸法機能について
* 選択した穴に応じた寸法を自動で作成します。
* 作成する寸法の書式はHOLE_DIM*.csvによって定義されます。
* CSVファイルの番号はHOLE_NUMBERに対応しています。_
* HOLE_DIM*.csvはiCADのUSER\Manufactureフォルダに配置してください。
(例: C:\ICADSX\USER\Manufacture)
* 寸法の書式については同梱のHOLE_DIM*.csvサンプルを参考にしてください。
* 貫通穴表記にチェックを入れると貫通属性のある穴の深さ部分を"貫通"に置き換えます。

### 精度穴ハッチングについて
* 選択した円形状にハッチングを追加します。
* 精度穴であるかの判定は行いません。

### 表面性状について
* ショートカットの除去加工の値はiCAD SXの環境セットアップ「表面粗さ」タブにて設定されているパラメータが呼び出されます。

### 図面化-「更新(ﾒｯｾｰｼﾞ無)について
* 更新時の「2次元形状は最新の～～」および「長さ寸法が線分の中点を～～」メッセージを表示させずに更新します。

### 半自動製図について
* ビュー間距離が短すぎるとエラーを起こします。その際はビュー間距離を広くし直してから再実行してください。


## 著作権/利用条件/免責等について
* 本プログラムに関する著作権等の知的財産権はものづくりのススメ-しれっとプロジェクトに帰属します
* 本プログラムは一切の保証なく、現状で提供されるものであり、正常動作等について作者は保証を行いません
* 本プログラムに関して発生するいかなる問題も利用者の責任により解決されるものとします
* 本プログラムに関して発生するいかなる損害に対しても作者は責任を負いません

上記に同意される場合のみ、本プログラムをご利用ください。

## 連絡先
本プログラムに関する不具合、ご要望等は[「ものづくりのススメ」お問い合わせフォーム](https://forms.gle/99xG3r8NDN7NX5QH9)よりご連絡ください。

---
Copyright (c) 2025 ものづくりのススメ-しれっとプロジェクト all aights reserved. 