# シャフト編集ツール

## バージョン
1.3.0
### 1.0.0
リリース
### 1.1.0 
段付き部の逃がし溝機能を追加
### 1.2.0
V8L2以前の場合に側面タップ穴が正常に作成できない不具合を修正
### 1.3.0
止め輪やタップ穴を各社オリジナルのファイルを利用している場合に対応するため、CSVファイルから任意設定できるように変更

## 概要
本ツールは、円柱形状に止め輪やキー溝を追加するツールです。

## 導入前の注意事項
* 導入前に必ず、**iCADインストールフォルダごとバックアップ**を作成してください。
* 本ツールはiCADのSDKを利用して作成されています。あらかじめiCAD SX の.NET連携機能を有効にしてください。
    * .NET連携機能有効化の手順
    1. スタートメニュー → iCAD SX 環境設定ツール → .NET連携セットアップ を起動する。
    2. ポート番号を「3999」（初期設定値のまま）にし、「.NET連携を有効にする」のチェックをONにする。     
* 本ツールはあらかじめテストをしてから配布をしておりますが、万が一損害が生じた場合の一切の責任を負いかねますので、ご了承ください。

## テスト実施済環境
### iCAD SXのバージョン
V8L3, V7L7
### OS
Windows 10

## インストール
1. ダウンロードファイルを解凍する
2. 解凍した**ShaftModelingTool**フォルダを**iCADインストールフォルダ\USER\BIN**へコピー
* アップデートの場合、"parameter"フォルダ内のCSVファイルをあらかじめ別の場所へ退避し、新しいバージョンをインストール後に"parameter"フォルダ内のCSVファイルを上書きしてください。

## 使用方法
1. ShaftModelingTool.exeの実行
	##### コマンドメニューもしくはアイコンメニューへ登録
	- 任意でコマンドメニューもしくはアイコンメニューへ登録してください。
	##### ShaftModelingTool.exeの実行
	- 登録したメニュー（コマンドメニュー、アイコンメニュー）　　
	- iCAD_キー入力領域からのexe実行[;EXEC /%ICADDIR%\USER\BIN\ShaftModelingTool\ShaftModelingTool.exe/ @GO]　
	- iCAD_アプリ実行
	- exeの直接起動  
	上記各方法により実行できます。
2. 使用したい機能を選択
   - 端面からの距離を入力
3. 実行ボタンをクリック
   - iCADがアクティブになります。
   - iCADを起動していない状態や、iCADの子ウィンドウがない状態で実行するとエラーメッセージがでます。
4. iCAD上で編集したい円柱の円筒面をクリック
5. iCAD上で編集したい円柱の端面をクリック
6. 終了時は✕ボタンで終了
   
### 設定変更方法
本ツールによって追加される形状の寸法は"parameter"フォルダ内のCSVファイルによって管理されています。CSVファイル内の値を変更することで、追加される形状の寸法を変更できます。CSVファイルには"dSTART"、"dEND"という項目があります。編集対象の軸の直径が"dSTART"より大きく"dEND"以下の場合の寸法を指定します。"dSTART"、"dEND"の値も任意で変更可能です。
#### "止め輪溝のみ"の寸法
- ShaftModelingToolLIST_clipGroove.csv で管理されます。
- cDia：溝の内径
- cWidth：溝の幅
#### "溝+C型止め輪"の寸法
- ShaftModelingToolLIST_Cclip.csv で管理されます。
- cYobi：止め輪の呼び（%ICADDIR%\JISPARTS\JIS\3D\09_止め輪\Ｃ形止め輪\軸用\軸用.csv の内容と一致させてください）
- cDia：溝の内径
- cWidth：溝の幅
#### "溝+E型止め輪"の寸法
- ShaftModelingToolLIST_Eclip.csv で管理されます。
- eYobi：止め輪の呼び（%ICADDIR%\JISPARTS\JIS\3D\09_止め輪\Ｅ形止め輪\Ｅ形止め輪.csv の内容と一致させてください）
- eDia：溝の内径
- eWidth：溝の幅
#### "キー溝"の寸法
- ShaftModelingToolLIST_KeySlot.csv で管理されます。
- slotDepth：キー溝の深さ
- slotWidth：キー溝の幅
- slotLength：キー溝の長さ
#### "一面取り(Dカット)"の寸法
- ShaftModelingToolLIST_SingleFlat.csv で管理されます。
- sfDepth：面取りの深さ
- sfLength：面取りの長さ
#### "二面取り"の寸法
- ShaftModelingToolLIST_WrenchFlats.csv で管理されます。
- wfWidth：二面取りの幅（スパナ幅）
- wfLength：二面取りの長さ
#### "側面タップ穴"の寸法
- ShaftModelingToolLIST_Tap_blind.csv で管理されます。
- tbYobi：タップの呼び径（%ICADDIR%\JISPARTS\JIS\3D\04_ねじ穴\タップ穴(下穴連動)\タップ穴(下穴連動).csv の内容と一致させてください）
#### "側面タップ穴(貫通)"の寸法
- ShaftModelingToolLIST_Tap_through.csv で管理されます。
- ttYobi：タップの呼び径（%ICADDIR%\JISPARTS\JIS\3D\04_ねじ穴\タップ穴(貫通形状)\タップ穴(貫通形状).csv の内容と一致させてください）
#### "段付き軸の逃がし溝"の寸法
- ShaftModelingToolLIST_stepGroove.csv で管理されます
- cDia：溝の内径
- cWidth：溝の幅

### MachinePartDirSetting.csv　について
本ツールでは、止め輪やタップ穴の形状ファイルを指定するために、MachinePartDirSetting.csvを使用します。MachinePartDirSetting.csvは"parameter"フォルダ内にあります。デフォルトではiCADのJISPARTSフォルダーを参照するように設定されていますが、各社オリジナルの形状ファイルを使用する場合は、MachinePartDirSetting.csv内のパスを変更してください。

### V8L2以前のiCADについて
V8L2以前のiCADでは側面タップ穴（貫通、非貫通ともに）を追加した際に、ダミーの細い円柱が部品構成要素として作成されます。必要に応じて部員構成要素を手動で削除してください。

## 著作権/利用条件/免責等について
* 本プログラムに関する著作権等の知的財産権はものづくりのススメ-しれっとプロジェクトに帰属します
* 本プログラムは一切の保証なく、現状で提供されるものであり、正常動作等について作者は保証を行いません
* 本プログラムに関して発生するいかなる問題も利用者の責任により解決されるものとします
* 本プログラムに関して発生するいかなる損害に対しても作者は責任を負いません

上記に同意される場合のみ、本プログラムをご利用ください。

## 連絡先
本プログラムに関する不具合、ご要望等は[「ものづくりのススメ」お問い合わせフォーム](https://forms.gle/99xG3r8NDN7NX5QH9)よりご連絡ください。

---
Copyright (c) 2024 ものづくりのススメ-しれっとプロジェクト all aights reserved. 